
# Custom Colors and Sizes
# Copyright 2008 by Alexander V. Christensen

"""
Edit the default colors and sizes in the GanttPV option file.
"""

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 080731 - first version

print Data.Option

import StartupData

colors = [
    "Child Color",
    "Parent Color",
    "Hidden Color",
    "Deleted Color",
    0,
    "Plan Bar",
    "Completion Bar",
    "Actual Bar",
    "Base Bar",
    0,
    "Work Day",
    "Work Day Selected",
    "Not Work Day",
    "Not Work Day Selected",
    ]

sizes = [
    "Grid Row Size",
    "Grid Column Size",
    "Grid Row Label Size",
    "Grid Column Label Size",
    0,
    "Gantt Row Size",
    "Gantt Column Size",
    ]

labels = {
    "Child Color": "Normal Row",
    "Parent Color": "Parent Row",
    "Hidden Color": "Hidden Row",
    "Deleted Color": "Deleted Row",
}

defaults = {
    "GridRowSize": 24,
    "GridColumnSize": 40,
    "GridRowLabelSize": 40,
    "GridColumnLabelSize": 40,
    "GanttRowSize": 28,
    "GanttColumnSize": 24,
}

def RGBtoHex(rgb):
    try:
        return "%02x%02x%02x" % rgb
    except (TypeError, ValueError):
        return ""

def RefreshMainWindowColors():
    main_list = Data.OpenReports[1].main_list

    other = Data.Option
    main_list.attrhidden = wx.ListItemAttr()
    main_list.attrhidden.SetBackgroundColour(other.get('HiddenColor', 'light grey'))

    main_list.attrdeleted = wx.ListItemAttr()
    main_list.attrdeleted.SetBackgroundColour(other.get('DeletedColor', "pink"))

    main_list.attrproject = wx.ListItemAttr()
    main_list.attrproject.SetBackgroundColour(other.get('ParentColor', "pale green"))

    main_list.attrreport = wx.ListItemAttr()
    main_list.attrreport.SetBackgroundColour(other.get('ChildColor', "khaki"))

def ReopenReports():
    RefreshMainWindowColors()

    reports = []
    for k in Data.OpenReports:
        v = Data.Report[k]
        if v.get('Open'):
            reports.append((v.get('WindowOrder'), k))
    reports.sort()
    Data.CloseReports()
    for order, id in reports:
        Data.OpenReport(id)

class GanttOptionsDialog(wx.Dialog):
    def __init__(self, parent):
        wx.Dialog.__init__(self, parent, -1, 'Custom Colors and Sizes')

        border_sizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer = wx.BoxSizer(wx.VERTICAL)
        grid_sizer = wx.FlexGridSizer(1, 0, hgap=30, vgap=5)

        left_sizer = wx.FlexGridSizer(0, 2, hgap=10, vgap=5)
        self.color_ctrls = []
        for color in colors:
            if not color:
                left_sizer.Add((10, 10))
                left_sizer.Add((10, 10))
                self.color_ctrls.append(0)
                continue

            label = wx.StaticText(self, -1, labels.get(color, color))
            left_sizer.Add(label, 0, wx.ALIGN_RIGHT | wx.ALIGN_CENTER_VERTICAL)

            ctrl = wx.TextCtrl(self, -1, size=(60, 25))
            key = color.replace(" ", "")
            value = RGBtoHex(Data.Option.get(key) or defaults.get(key))
            ctrl.SetValue(value)
            self.color_ctrls.append(ctrl)
            left_sizer.Add(ctrl, 0)
        grid_sizer.Add(left_sizer)

        right_sizer = wx.FlexGridSizer(0, 2, hgap=10, vgap=5)
        self.size_ctrls = []
        for size in sizes:
            if not size:
                right_sizer.Add((10, 10))
                right_sizer.Add((10, 10))
                self.size_ctrls.append(0)
                continue

            label = wx.StaticText(self, -1, labels.get(size, size))
            right_sizer.Add(label, 0, wx.ALIGN_RIGHT | wx.ALIGN_CENTER_VERTICAL)

            ctrl = wx.TextCtrl(self, -1, size=(60, 25))
            key = size.replace(" ", "")
            value = str(Data.Option.get(key) or defaults.get(key) or "")
            ctrl.SetValue(value)
            self.size_ctrls.append(ctrl)
            right_sizer.Add(ctrl, 0)
        grid_sizer.Add(right_sizer)

        sizer.Add(grid_sizer)
        sizer.Add((10, 10))

        buttons = wx.BoxSizer(wx.HORIZONTAL)
        cancelbutton = wx.Button(self, wx.ID_CANCEL, "Cancel", size=(70, 20))
        buttons.Add(cancelbutton, 0, wx.ALIGN_CENTER_VERTICAL)
        buttons.Add((10, 10))
        ID_restore_defaults = wx.NewId()
        defaultsbutton = wx.Button(self, ID_restore_defaults, "Restore Defaults", size=(140, 20))
        buttons.Add(defaultsbutton, 0, wx.ALIGN_CENTER_VERTICAL)
        okbutton = wx.Button(self, wx.ID_OK, "OK", size=(70, 20))
        okbutton.SetDefault()
        buttons.Add((10, 10))
        buttons.Add(okbutton, 0, wx.ALIGN_CENTER_VERTICAL)
        sizer.Add(buttons, 0, wx.ALIGN_RIGHT)

        border_sizer.Add(sizer, 0, wx.ALL | wx.ALIGN_CENTRE, 10)
        self.SetSizer(border_sizer)
        self.Fit()
        self.CentreOnScreen()

        wx.EVT_BUTTON(self, ID_restore_defaults, self.OnRestoreDefaults)
        wx.EVT_BUTTON(self, wx.ID_OK, self.OnOK)

    def OnRestoreDefaults(self, event):
        startup = StartupData.GanttPVOptions()
        for color, ctrl in zip(colors, self.color_ctrls):
            if not color:
                continue
            key = color.replace(" ", "")
            value = RGBtoHex(startup.get(key) or defaults.get(key))
            ctrl.SetValue(value)
        for size, ctrl in zip(sizes, self.size_ctrls):
            if not size:
                continue
            key = size.replace(" ", "")
            value = str(startup.get(key) or defaults.get(key) or "")
            ctrl.SetValue(value)

    def OnOK(self, event):
        for color, ctrl in zip(colors, self.color_ctrls):
            if not color:
                continue
            value = ctrl.GetValue()
            values = value[0:2], value[2:4], value[4:6]
            try:
                values = [int(v, 16) for v in values]
            except ValueError:
                continue
            key = color.replace(" ", "")
            Data.Option[key] = tuple(values)
            if color[-3:] == 'Bar':
                Data.Option[key + 'Selected'] = tuple(values)
        for size, ctrl in zip(sizes, self.size_ctrls):
            if not size:
                continue
            value = ctrl.GetValue()
            try:
                value = int(value)
            except ValueError:
                continue
            if value > 0:
                Data.Option[size.replace(" ", "")] = value
        Data.SaveOption()
        ReopenReports()
        event.Skip()

def Do():
    dlg = GanttOptionsDialog(None)
    dlg.Show()

Do()